import Foundation

class CheckOrderStatusSDK {
    
    func checkOrderStatus(userToken: String, orderID: String, completion: @escaping (Result<OrderStatusResponse, Error>) -> Void) {
        
        let apiUrl = URL(string: "https://khilaadixpro.shop/api/check-order-status")!
        
        var request = URLRequest(url: apiUrl)
        request.httpMethod = "POST"
        
        let parameters = ["user_token": userToken, "order_id": orderID]
        let formData = parameters.map { key, value in
            return "\(key)=\(value)"
        }.joined(separator: "&")
        
        request.httpBody = formData.data(using: .utf8)
        request.setValue("application/x-www-form-urlencoded", forHTTPHeaderField: "Content-Type")
        
        let task = URLSession.shared.dataTask(with: request) { (data, response, error) in
            if let error = error {
                completion(.failure(error))
                return
            }
            
            guard let data = data else {
                completion(.failure(NSError(domain: "Response data is empty", code: 0, userInfo: nil)))
                return
            }
            
            do {
                let decoder = JSONDecoder()
                let orderStatusResponse = try decoder.decode(OrderStatusResponse.self, from: data)
                completion(.success(orderStatusResponse))
            } catch {
                completion(.failure(error))
            }
        }
        
        task.resume()
    }
}

struct OrderStatusResponse: Codable {
    let status: String
    let message: String
    let result: OrderResult
}

struct OrderResult: Codable {
    let txnStatus: String
    let resultInfo: String
    let orderId: String
    let status: String
    let amount: String
    let date: String
    let utr: String
}
